% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental-features.R
\name{calculate_eds}
\alias{calculate_eds}
\title{Calculate ED5, ED50, and ED95 values for all samples in the dataset.}
\usage{
calculate_eds(
  cbass_dataset,
  grouping_properties = c("Site", "Condition", "Species", "Timepoint"),
  drm_formula = "Pam_value ~ Temperature"
)
}
\arguments{
\item{cbass_dataset}{A data frame containing the dataset to be processed.}

\item{grouping_properties}{A character vector of column names to be used for grouping. Default: c("Site", "Condition", "Species", "Timepoint").}

\item{drm_formula}{A formula object specifying the dose-response model. Default: "Pam_value ~ Temperature".}
}
\value{
A data frame with ED5, ED50, and ED95 values for each grouping property.
}
\description{
Calculate ED5, ED50, and ED95 values for all samples in the dataset.
}
\examples{
# Example dataset
data(cbass_dataset)

# Extract the ED5, ED50, and ED95 values as a data frame
eds_df <- calculate_eds(cbass_dataset)
}
