% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_PolyGrids}
\alias{create_PolyGrids}
\title{Create a Polygon Grid}
\usage{
create_PolyGrids(
  Input,
  NamesIn = NULL,
  dlon = NA,
  dlat = NA,
  Area = NA,
  cuts = 100,
  cols = c("green", "yellow", "red"),
  Blank = FALSE
)
}
\arguments{
\item{Input}{input dataframe.

If \code{NamesIn} is not provided, the columns in the \code{Input} must be in the following order:

Latitude, Longitude, Variable 1, Variable 2 ... Variable x.}

\item{NamesIn}{character vector of length 2 specifying the column names of Latitude and Longitude fields in
the \code{Input}. Latitudes name must be given first, e.g.:

\code{NamesIn=c('MyLatitudes','MyLongitudes')}.}

\item{dlon}{numeric, width of the grid cells in decimal degrees of longitude.}

\item{dlat}{numeric, height of the grid cells in decimal degrees of latitude.}

\item{Area}{numeric, area in square kilometers of the grid cells. The smaller the \code{Area}, the longer it will take.}

\item{cuts}{numeric, number of desired color classes.}

\item{cols}{character, desired colors. If more that one color is provided, a linear color gradient is generated.}

\item{Blank}{logical, \code{TRUE} or \code{FALSE}. If \code{TRUE}, creates an empty grid spanning the bounding box
given in the \code{Input} as: \code{c(LatMin,LatMax,LonMin,LonMax)}. The script might struggle to reach equal-area
gridding if the desired cell \code{Area} is too large, and/or the \code{Input} bounding box is too small,
and/or the \code{Input} bounding box does not span -180 to 180 degrees longitude. Use \code{Blank=TRUE} with caution.}
}
\value{
Spatial object in your environment.

if \code{Blank=FALSE}:

Data within the resulting spatial object contains the data provided in the \code{Input} after aggregation
within cells. For each Variable, the minimum, maximum, mean, sum, count, standard deviation, and, 
median of values in each cell is returned. In addition, for each cell, its area (AreaKm2), projected 
centroid (Centrex, Centrey) and unprojected centroid (Centrelon, Centrelat) is given. Also, colors are
generated for each aggregated values according to the chosen \code{cuts} and \code{cols}. To generate a
custom color scale after the grid creation, refer to \code{\link{add_col}} and \code{\link{add_Cscale}}.


if \code{Blank=TRUE}:

An empty grid is generated. It can be re-used across scripts in conjunction
with \code{\link{assign_areas}}.
}
\description{
Create a polygon grid to spatially aggregate data in cells of chosen size.
Cell size may be specified in degrees or as a desired area in square kilometers
(in which case cells are of equal area). Using \code{Blank=TRUE} (with caution) produces
an empty grid.
}
\examples{
\donttest{

# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#create-grids
# And:
# https://github.com/ccamlr/CCAMLRGIS/blob/master/Advanced_Grids/Advanced_Grids.md

#Simple grid, using automatic colors

MyGrid=create_PolyGrids(Input=GridData,dlon=2,dlat=1)
#View(MyGrid)
plot(st_geometry(MyGrid),col=MyGrid$Col_Catch_sum)


}

}
\seealso{
\code{\link{create_Points}}, \code{\link{create_Lines}}, \code{\link{create_Polys}},
\code{\link{create_Stations}}, \code{\link{create_Pies}}, \code{\link{add_col}},
 \code{\link{add_Cscale}}, \code{\link{add_Legend}}.
}
