% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCMnet_theoretical_check.R
\name{sample_theoretical}
\alias{sample_theoretical}
\title{Generate Samples from Target Distributions}
\usage{
sample_theoretical(object, n_sim = nrow(object$mcmc_stats))
}
\arguments{
\item{object}{An object of class \code{ccm_sample} generated by \code{\link{sample_ccm}}.}

\item{n_sim}{Integer. The number of independent samples to draw from the 
theoretical target distributions. Default is equal to the number of CCM samples.}
}
\value{
The input \code{ccm_sample} object with the \code{theoretical} slot 
  populated. This slot contains a data frame of statistics sampled directly 
  from the target distributions.
}
\description{
This function draws samples directly from the target probability distributions 
specified in a \code{ccm_sample} object. These samples serve as a "ground truth" 
to evaluate whether the MCMC chain has converged to the intended target.
}
\details{
This function performs direct i.i.d. sampling (e.g., using \code{rpois}, 
\code{rnorm}, etc.) based on the parameters stored in the \code{ccm_sample} 
object. It does not use MCMC. The resulting samples are used by 
\code{\link{plot.ccm_sample}} when \code{include_theoretical = TRUE} is specified.
}
\examples{
# 1. Generate MCMC samples
ccm_sample <- sample_ccm(
  network_stats = "edges",
  prob_distr = "poisson",
  prob_distr_params = list(list(350)),
  population = 50 
)

# 2. Generate theoretical samples for comparison
ccm_sample <- sample_theoretical(ccm_sample, n_sim = 1000)

# 3. Compare MCMC to theoretical target
plot(ccm_sample, stats = "edges", type = "hist", include_theoretical = TRUE)

}
