% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutationDistances.r
\name{distancePermutationSwapInv}
\alias{distancePermutationSwapInv}
\title{Inverse-Swap-Distance for Permutations}
\usage{
distancePermutationSwapInv(x, y)
}
\arguments{
\item{x}{first permutation (integer vector)}

\item{y}{second permutation (integer vector)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1 (based on the maximum possible distance between two permutations)
}
\description{
The swap distance on the inverse of permutations x and y.
See \code{\link{distancePermutationSwap}} for non-inversed version.
}
\examples{
x <- 1:5
y <- c(1,2,3,5,4)
distancePermutationSwapInv(x,y)
p <- replicate(10,sample(1:5),simplify=FALSE)
distanceMatrix(p,distancePermutationSwapInv)

}
