% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traditional_functions.R
\name{traditional_regression_functions}
\alias{traditional_regression_functions}
\alias{mult_reg}
\alias{res_reg}
\title{Traditional regression approaches.}
\usage{
mult_reg(setting = "GLM", Y = NULL, X = NULL, K = NULL, L = NULL,
  C = NULL)

res_reg(Y = NULL, X = NULL, K = NULL, L = NULL)
}
\arguments{
\item{setting}{String with value \code{"GLM"} or \code{"AFT"} indicating
whether the approaches are fitted for a normally-distributed
primary outcome \code{Y} (\code{"GLM"}) or a censored
time-to-event primary outcome \code{Y} (\code{"AFT"}). Under
the \code{"AFT"} setting, only \code{mult_reg} is
available.}

\item{Y}{Numeric input vector of the primary outcome.}

\item{X}{Numeric input vector of the exposure variable.}

\item{K}{Numeric input vector of the intermediate outcome.}

\item{L}{Numeric input vector of the observed confounding factor.}

\item{C}{Numeric input vector of the censoring indicator under the AFT setting
(must be coded 0 = censored, 1 = uncensored).}
}
\value{
Returns a list with point estimates of the parameters
        \code{point_estimates}, standard error estimates \code{SE_estimates}
        and p-values \code{pvalues}.
}
\description{
Functions to fit traditional regression approaches for a quantitative
normally-distributed primary outcome (\code{setting} = \code{"GLM"})
and a censoredtime-to-event primary outcome (\code{setting} = \code{"AFT"}).
\code{\link{mult_reg}} fits the multiple regression approach and
\code{\link{res_reg}} computes the regression of residuals approach.
}
\details{
In more detail, for a quantitative normally-distributed primary outcome
\code{Y}, \code{\link{mult_reg}} fits the model
\deqn{Y = \alpha_0 + \alpha_1 \cdot K + \alpha_{XY} \cdot X + \alpha_2 \cdot L + \epsilon}{Y = \alpha0 + \alpha1*K + \alphaXY*X + \alpha2*L + \epsilon}
and obtains point and standard error estimates for the parameters
\eqn{\alpha_0, \alpha_1, \alpha_{XY}, \alpha_2}{\alpha0, \alpha1, \alphaXY, \alpha2}.
\code{\link{res_reg}} obtains point and standard
error estimates for the parameters
\eqn{\alpha_0, \alpha_1, \alpha_2, \alpha_3, \alpha_{XY}}{\alpha0, \alpha1, \alpha2, \alpha3, \alphaXY}
by fitting the models
\deqn{Y = \alpha_0 + \alpha_1 \cdot K + \alpha_2 \cdot L + \epsilon_1}{Y = \alpha0 + \alpha1*K + \alpha2*L + \epsilon1,}
\deqn{\widehat{\epsilon}_1 = \alpha_3 + \alpha_{XY} \cdot X + \epsilon_2}{hat(\epsilon1) = \alpha3 + \alphaXY*X + \epsilon2.}
Both functions use the \code{\link[stats]{lm}} function and also report the
provided p-values from t-tests that each parameter equals 0.
For the analysis of a censored time-to-event primary outcome \code{Y},
only the multiple regression approach is implemented. Here,
\code{\link{mult_reg}} fits the according censored regression model to obtain
coefficient and standard error estimates as well as p-values from large-sample
Wald-type tests by using the \code{\link[survival]{survreg}} function.
See the vignette for more details.
}
\examples{

dat_GLM <- generate_data(setting = "GLM")
mult_reg(setting = "GLM", Y = dat_GLM$Y, X = dat_GLM$X, K = dat_GLM$K,
         L = dat_GLM$L)
res_reg(Y = dat_GLM$Y, X = dat_GLM$X, K = dat_GLM$K, L = dat_GLM$L)

dat_AFT <- generate_data(setting = "AFT", a = 0.2, b = 4.75)
mult_reg(setting = "AFT", Y = dat_AFT$Y, X = dat_AFT$X, K = dat_AFT$K,
         L = dat_AFT$L, C = dat_AFT$C)

}
