% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_estimate_iptw_ate.R
\name{ce_estimate_iptw_ate}
\alias{ce_estimate_iptw_ate}
\title{Causal inference with multiple treatments using IPTW for ATE effects}
\usage{
ce_estimate_iptw_ate(y, w, x, method, ...)
}
\arguments{
\item{y}{A numeric vector (0, 1) representing a binary outcome.}

\item{w}{A numeric vector representing the treatment groups.}

\item{x}{A dataframe, including all the covariates but not treatments.}

\item{method}{A character string. Users can selected from the
following methods including \code{"IPTW-Multinomial"},
\code{"IPTW-GBM"}, \code{"IPTW-SL"}.}

\item{...}{Other parameters that can be passed through to functions.}
}
\value{
A summary of the effect estimates can be obtained
with \code{summary} function. The weight distributions can be
visualized using \code{plot} function.
}
\description{
The function \code{ce_estimate_iptw_ate} implements
IPTW to estimate ATE effect with
multiple treatments using observational data.
}
\references{
Venables, W. N. & Ripley, B. D. (2002)
\emph{Modern Applied Statistics with S}.
Fourth Edition. Springer, New York. ISBN 0-387-95457-0

Matthew Cefalu, Greg Ridgeway, Dan McCaffrey,
Andrew Morral, Beth Ann Griffin and Lane Burgette (2021).
\emph{twang: Toolkit for Weighting and Analysis of Nonequivalent Groups}.
R package version 2.5. URL:\url{https://CRAN.R-project.org/package=twang}

Noah Greifer (2021).
\emph{WeightIt: Weighting for Covariate Balance in Observational Studies}.
R package version 0.12.0.
URL:\url{https://CRAN.R-project.org/package=WeightIt}
}
