% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_switchgear_secondary_10kv.R
\name{network_cof_switchgear_secondary_10kv}
\alias{network_cof_switchgear_secondary_10kv}
\title{Network cost of Failure for 10kV Switchgear Secondary}
\usage{
network_cof_switchgear_secondary_10kv(
  no_customers,
  kva_per_customer = "Default"
)
}
\arguments{
\item{no_customers}{Numeric. The number of customers
fed by an individual asset.}

\item{kva_per_customer}{Numeric. If the asset have an exceptionally high
demand per customer type in kVA per customer. A setting of \code{"Default"}
results in a multiplication factor of 1 (cf. table 18, page 90, CNAIM, 2021).}
}
\value{
Numeric. Network cost of failure.
}
\description{
This function calculates network cost of failure for
10kV Switchgear Secondary
Network cost of failure
is used in the derivation of consequences of failure see \code{\link{cof}}().
Outputted in DKK.
}
\examples{
network_cof_switchgear_secondary_10kv(
no_customers = 750, kva_per_customer = 51)
}
