#' segStats
#'
#' This function allows you to get an overview of some of the features of your
#' samples. It outputs a summary of stats for the segments, including size,
#' number per sample, along with various other measures.
#'
#' @param segTabs The list of samples copy number segments
#' @keywords segmentation stats statistics summary
#' @return Outputs a summary of the statistics
#' @export
#' @examples
#' segStats(segDataExp)
segStats <- function(segTabs){

   #Creates empty vectors to fill
   segDists<-numeric()
   segLength<-numeric()
   segNum<-numeric()
   segVals<-numeric()

   #Goes through every sample in the list
   for (id in names(segTabs)){
      sample<-segTabs[[id]]

      segNum<-c(segNum,nrow(sample)) #Number of segments
      segLength<-c(segLength,sample$end-sample$start) #Length of segments
      segVals<-c(segVals,sample$segVal) #segment Values

      #Goes through every segment and if it is on the same chromosome
      #as the previous segment, it find the distance between them
      for (i in 2:nrow(sample)){
         if(sample[i,1] == sample[i-1,1])
            segDists<-c(segDists,sample[i,2]-sample[i-1,3])
      }
   }

   results<-cbind(summary(segVals),summary(segNum),
                  summary(segLength),summary(segDists))
   colnames(results)<-c("SegVals","Number of Segments","Segment Length",
                        "Distance Between Segments")
   return(results)
}
