% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{selectParams}
\alias{selectParams}
\title{Select the parameters in COAP models}
\usage{
selectParams(
  X_count,
  Z,
  multiFac = rep(1, nrow(X_count)),
  q_max = 15,
  r_max = 24,
  threshold = c(0.1, 0.01),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{X_count}{a count matrix, the observed count matrix.}

\item{Z}{an optional matrix, the covariate matrix; default as a full-one column vector if there is no additional covariates.}

\item{multiFac}{an optional vector, the normalization factor for each unit; default as full-one vector.}

\item{q_max}{an optional string, specify the upper bound for the number of factors; default as 15.}

\item{r_max}{an optional integer, specify the upper bound for the rank of the regression coefficient matrix; default as 24.}

\item{threshold}{an optional 2-dimensional positive vector, specify the the thresholds that filters the singular values of beta and B, respectively.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{..., }{other arguments passed to the function \code{\link{RR_COAP}}.}
}
\value{
return a named vector with names `hr` and `hq`, the estimated rank and number of factors.
}
\description{
Select the number of factors and the rank of coefficient matrix in the covariate-augmented overdispersed Poisson factor model
}
\details{
The threshold is to filter the singular values with  low signal, to assist the identification of underlying model structure.
}
\examples{
n <- 300; p <- 100
d <- 20; q <- 6; r <- 3
datlist <- gendata_simu(seed=30, n=n, p=p, d=20, q=q, rank0=r)
str(datlist)
set.seed(1)
para_vec <- selectParams(X_count=datlist$X, Z = datlist$Z)
print(para_vec)
}
\references{
None
}
\seealso{
\code{\link{RR_COAP}}
}
