% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_units.R
\name{Screen.coin}
\alias{Screen.coin}
\title{Screen units based on data availability}
\usage{
\method{Screen}{coin}(
  x,
  dset,
  unit_screen,
  dat_thresh = NULL,
  nonzero_thresh = NULL,
  Force = NULL,
  out2 = "coin",
  write_to = NULL,
  ...
)
}
\arguments{
\item{x}{A coin}

\item{dset}{The data set to be checked/screened}

\item{unit_screen}{Specifies whether and how to screen units based on data availability or zero values.
\itemize{
\item If set to \code{"byNA"}, screens units with data availability below \code{dat_thresh}
\item If set to \code{"byzeros"}, screens units with non-zero values below \code{nonzero_thresh}
\item If set to \code{"byNAandzeros"}, screens units based on either of the previous two criteria being true.
}}

\item{dat_thresh}{A data availability threshold (\verb{>= 1} and \verb{<= 0}) used for flagging low data and screening units if \code{unit_screen != "none"}. Default 0.66.}

\item{nonzero_thresh}{As \code{dat_thresh} but for non-zero values. Defaults to 0.05, i.e. it will flag any units with less than 5\% non-zero values (equivalently more than 95\% zero values).}

\item{Force}{A data frame with any additional countries to force inclusion or exclusion. Required columns \code{uCode}
(unit code(s)) and \code{Include} (logical: \code{TRUE} to include and \code{FALSE} to exclude). Specifications here override
exclusion/inclusion based on data rules.}

\item{out2}{Where to output the results. If \code{"COIN"} (default for COIN input), appends to updated COIN,
otherwise if \code{"list"} outputs to data frame.}

\item{write_to}{If specified, writes the aggregated data to \code{.$Data[[write_to]]}. Default \code{write_to = "Screened"}.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated coin with data frames showing missing data in \code{.$Analysis}, and a new data set \code{.$Data$Screened}.
If \code{out2 = "list"} wraps missing data stats and screened data set into a list.
}
\description{
Screens units based on a data availability threshold and presence of zeros. Units can be optionally
"forced" to be included or excluded, making exceptions for the data availability threshold.
}
\details{
The two main criteria of interest are \code{NA} values, and zeros. The summary table gives percentages of
\code{NA} values for each unit, across indicators, and percentage zero values (\emph{as a percentage of non-\code{NA} values}).
Each unit is flagged as having low data or too many zeros based on thresholds.

See also \code{vignette("screening")}.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "new_coin", quietly = TRUE)

# screen units from raw dset
coin <- Screen(coin, dset = "Raw", unit_screen = "byNA",
               dat_thresh = 0.85, write_to = "Filtered_85pc")

# some details about the coin by calling its print method
coin

}
