% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full.plot.regularity.thresholds.R
\name{full.plot.regularity.thresholds}
\alias{full.plot.regularity.thresholds}
\title{Plots the rate functions after filtering them according to a given penalty and predefined thresholds.}
\usage{
full.plot.regularity.thresholds(
  samples,
  filtering_fractions = c(0.01, 0.05, 0.2, 0.9),
  penalty = "L1",
  rates = c("lambda", "mu")
)
}
\arguments{
\item{samples}{A list of (congruent) CRABS models}

\item{filtering_fractions}{A vector of thresholds for filtering, as fractions of the most regular trajectories.}

\item{penalty}{The choice of penalty, among "L1", "L2" and "L1_derivative" (penalty on derivative shifts).}

\item{rates}{A vector of rate(s) to be plotted, among "lambda" (speciation), "mu" (extinction), "delta" (net-diversification) and "epsilon" (turnover).}
}
\value{
Plots an array of rate trajectories for the chosen rates and thresholds.
}
\description{
Plots the rate functions after filtering them according to a given penalty and predefined thresholds.
}
\examples{
data("primates_ebd")
set.seed(123)

l <- approxfun(primates_ebd[["time"]], primates_ebd[["lambda"]])
mu <- approxfun(primates_ebd[["time"]], primates_ebd[["mu"]])
times <- primates_ebd[["time"]]

model <- create.model(l, mu, times)

sample.joint.rates <- function(n) {
  sample.basic.models.joint(times = times, 
                            p.delta = model$p.delta,  
                            beta.param = c(0.5,0.3),  
                            lambda0 = l(0.0),  
                            mu0.median = mu(0.0))
}

joint.samples <- sample.congruence.class(model = model, 
                                         num.samples = 100, 
                                         rate.type = "joint", 
                                         sample.joint.rates = sample.joint.rates)

full.plot.regularity.thresholds(joint.samples)
}
