% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cste_bin_SCB.R
\name{cste_bin_SCB}
\alias{cste_bin_SCB}
\title{Calculate simultaneous confidence bands of CSTE curve for binary outcome.}
\usage{
cste_bin_SCB(x, fit, h = NULL, alpha = 0.05)
}
\arguments{
\item{x}{samples of predictor, which is a \eqn{m*p} matrix.}

\item{fit}{a S3 class of cste.}

\item{h}{kernel bandwidth.}

\item{alpha}{the simultaneous confidence bands are of \eqn{1-\alpha} confidence level.}
}
\value{
A list which includes:
\itemize{
   \item \code{or_x}: the ordered value of \eqn{X\beta_1}. 
   \item \code{fit_x}: the fitted value of CSTE curve corresponding to \code{or_x}.
   \item \code{lower_bound}: the lower bound of CSTE's simultaneous confidence band.
   \item \code{upper_bound}: the upper bound of CSTE's simultaneous confidence band.
}
}
\description{
This function calculates simultaneous confidence bands of CSTE curve for binary 
outcome.
}
\references{
Guo W., Zhou X. and Ma S. (2021).
Estimation of Optimal Individualized Treatment Rules
Using a Covariate-Specific Treatment Effect Curve with 
High-dimensional Covariates,
\emph{Journal of the American Statistical Association}, 116(533), 309-321
}
\seealso{
\code{\link{cste_bin}}
}
