% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_InsertDim.R
\name{CST_InsertDim}
\alias{CST_InsertDim}
\title{Add a named dimension to an object of class s2dv_cube}
\usage{
CST_InsertDim(data, posdim, lendim, name, values = NULL)
}
\arguments{
\item{data}{An object of class \code{s2dv_cube} to which the additional
dimension should be added.}

\item{posdim}{An integer indicating the position of the new dimension.}

\item{lendim}{An integer indicating the length of the new dimension.}

\item{name}{A character string indicating the name for the new dimension.}

\item{values}{A vector containing the values of the new dimension and any
relevant attributes. If NULL, a sequence of integers from 1 to lendim will
be added.}
}
\value{
An object of class \code{s2dv_cube} with similar data, coordinates and 
attributes as the \code{data} input, but with an additional dimension.
}
\description{
Insert an extra dimension into an array at position 'posdim' with length 
'lendim'. The array in \code{data} repeats along the new dimension.
The dimensions, coordinates and attributes are modified accordingly.
}
\examples{
#Example with sample data:
# Check original dimensions and coordinates
lonlat_temp$exp$dims
names(lonlat_temp$exp$coords)
# Add 'variable' dimension
exp <- CST_InsertDim(lonlat_temp$exp,
                    posdim = 2,
                    lendim = 1,
                    name = "variable",
                    values = c("tas"))
# Check new dimensions and coordinates
exp$dims
exp$coords$variable

}
\seealso{
\link[s2dv]{InsertDim}
}
\author{
Agudetse Roures Victoria, \email{victoria.agudetse@bsc.es}
}
