% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_MergeDims.R
\name{CST_MergeDims}
\alias{CST_MergeDims}
\title{Function to  Merge Dimensions}
\usage{
CST_MergeDims(
  data,
  merge_dims = c("ftime", "monthly"),
  rename_dim = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{data}{An 's2dv_cube' object}

\item{merge_dims}{A character vector indicating the names of the dimensions to 
merge.}

\item{rename_dim}{a character string indicating the name of the output 
dimension. If left at NULL, the first dimension name provided in parameter 
\code{merge_dims} will be used.}

\item{na.rm}{A logical indicating if the NA values should be removed or not.}
}
\value{
An object of class \code{'s2dv_cube'} with the specified dimensions merged 
into a single dimension.
}
\description{
This function merges two dimensions of the array \code{data} in a 
's2dv_cube' object into one. The user can select the dimensions to merge and 
provide the final name of the dimension. The user can select to remove NA 
values or keep them.
}
\examples{
data <- 1 : c(2 * 3 * 4 * 5 * 6 * 7)
dim(data) <- c(time = 7, lat = 2, lon = 3, monthly = 4, member = 6,
              dataset = 5, var = 1)
data[2,,,,,,] <- NA
data[c(3,27)] <- NA
data <- list(data = data)
class(data) <- 's2dv_cube'
new_data <- CST_MergeDims(data, merge_dims = c('time', 'monthly'))
new_data <- CST_MergeDims(data, merge_dims = c('lon', 'lat'), rename_dim = 'grid')
new_data <- CST_MergeDims(data, merge_dims = c('time', 'monthly'), na.rm = TRUE)
}
\author{
Nuria Perez-Zanon, \email{nuria.perez@bsc.es}
}
