% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_SaveExp.R
\name{CST_SaveExp}
\alias{CST_SaveExp}
\title{Save objects of class 's2dv_cube' to data in NetCDF format}
\usage{
CST_SaveExp(
  data,
  destination = tempdir(),
  startdates = NULL,
  sdate_dim = "sdate",
  ftime_dim = "time",
  memb_dim = "member",
  dat_dim = "dataset",
  var_dim = "var",
  drop_dims = NULL,
  single_file = FALSE,
  extra_string = NULL,
  global_attrs = NULL,
  units_hours_since = FALSE
)
}
\arguments{
\item{data}{An object of class \code{s2dv_cube}.}

\item{destination}{A character string containing the directory name in which 
to save the data. NetCDF file for each starting date are saved into the 
folder tree: 'destination/Dataset/variable/'. By default the function 
saves the data into the working directory.}

\item{startdates}{A vector of dates that will be used for the filenames 
when saving the data in multiple files (single_file = FALSE). It must be a 
vector of the same length as the start date dimension of data. It must be a 
vector of class \code{Dates}, \code{'POSIXct'} or character with lenghts 
between 1 and 10. If it is NULL, the coordinate corresponding the the start 
date dimension or the first Date of each time step will be used as the name 
of the files. It is NULL by default.}

\item{sdate_dim}{A character string indicating the name of the start date 
dimension. By default, it is set to 'sdate'. It can be NULL if there is no
start date dimension.}

\item{ftime_dim}{A character string indicating the name of the forecast time
dimension. If 'Dates' are used, it can't be NULL. If there is no forecast 
time dimension, 'Dates' will be set to NULL and will not be used. By 
default, it is set to 'time'.}

\item{memb_dim}{A character string indicating the name of the member 
dimension. It can be NULL if there is no member dimension. By default, it is
 set to 'member'.}

\item{dat_dim}{A character string indicating the name of dataset dimension. 
It can be NULL if there is no dataset dimension. By default, it is set to 
'dataset'.}

\item{var_dim}{A character string indicating the name of variable dimension. 
It can be NULL if there is no variable dimension. By default, it is set to 
'var'.}

\item{drop_dims}{(optional) A vector of character strings indicating the 
dimension names of length 1 that need to be dropped in order that they don't 
appear in the netCDF file. Only is allowed to drop dimensions that are not 
used in the computation. The dimensions used in the computation are the ones 
specified in: sdate_dim, ftime_dim, dat_dim, var_dim and memb_dim. It is 
NULL by default.}

\item{single_file}{A logical value indicating if all object is saved in a 
single file (TRUE) or in multiple files (FALSE). When it is FALSE, 
the array is separated for datasets, variable and start date. When there are 
no specified time dimensions, the data will be saved in a single file by 
default. The output file name when 'single_file' is TRUE is a character 
string containing: '<var>_<first_sdate>_<last_sdate>.nc'; when it is FALSE, 
it is '<var>_<sdate>.nc'. It is FALSE by default.}

\item{extra_string}{(Optional) A character string to be included as part of 
the file name, for instance, to identify member or realization. When 
single_file is TRUE, the 'extra_string' will substitute all the default 
file name; when single_file is FALSE, the 'extra_string' will be added 
in the file name as: '<var>_<extra_string>_<sdate>.nc'. It is NULL by 
default.}

\item{global_attrs}{(Optional) A list with elements containing the global 
attributes to be saved in the NetCDF.}

\item{units_hours_since}{(Optional) A logical value only available for the 
case: 'Dates' have forecast time and start date dimension, 'single_file' is 
TRUE and 'time_bounds' are not used. When it is TRUE, it saves the forecast 
time with units of 'hours since'; if it is FALSE, the time units will be a 
number of time steps with its corresponding frequency (e.g. n days, n months 
or n hours). It is FALSE by default.}
}
\value{
Multiple or single NetCDF files containing the data array.\cr
\item{\code{single_file is TRUE}}{
 All data is saved in a single file located in the specified destination  
 path with the following name (by default): 
 '<variable_name>_<first_sdate>_<last_sdate>.nc'. Multiple variables
 are saved separately in the same file. The forecast time units 
 are calculated from each start date (if sdate_dim is not NULL) or from 
 the time step. If 'units_hours_since' is TRUE, the forecast time units 
 will be 'hours since <each start date>'. If 'units_hours_since' is FALSE, 
 the forecast time units are extracted from the frequency of the time steps 
 (hours, days, months); if no frequency is found, the units will be ’hours 
 since’. When the time units are 'hours since' the time ateps are assumed to 
 be equally spaced.
}
\item{\code{single_file is FALSE}}{
 The data array is subset and stored into multiple files. Each file 
 contains the data subset for each start date, variable and dataset. Files 
 with different variables and datasets are stored in separated directories 
 within the following directory tree: 'destination/Dataset/variable/'. 
 The name of each file will be by default: '<variable_name>_<sdate>.nc'. 
 The forecast time units are calculated from each start date (if sdate_dim 
 is not NULL) or from the time step. The forecast time units will be 'hours 
 since <each start date>'.
}
}
\description{
This function allows to divide and save a object of class 
's2dv_cube' into a NetCDF file, allowing to reload the saved data using 
\code{CST_Start} or \code{CST_Load} functions. It also allows to save any 
's2dv_cube' object that follows the NetCDF attributes conventions.
}
\examples{
data <- lonlat_temp_st$exp
CST_SaveExp(data = data, ftime_dim = 'ftime', var_dim = 'var', 
           dat_dim = 'dataset', sdate_dim = 'sdate')

}
\seealso{
\code{\link[startR]{Start}}, \code{\link{as.s2dv_cube}} and 
\code{\link{s2dv_cube}}
}
\author{
Perez-Zanon Nuria, \email{nuria.perez@bsc.es}
}
