% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_Observation.R
\name{list_Observations}
\alias{list_Observations}
\title{List Observations in the current PML set}
\usage{
list_Observations(
  PMLParametersSets,
  IncludeCustom = TRUE,
  ObservationsOnly = TRUE
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{IncludeCustom}{Logical. Should the names of responses (\code{observe},
\code{multi}, \code{ordinal}, \code{count}, \code{event} and \code{LL}) from the PML code of custom
spaces be included or not. Default is \code{TRUE}.}

\item{ObservationsOnly}{Logical. If \code{TRUE} (default), only the names of
\code{observe} responses are included in the PML code generated for custom
spaces.  Non-observed response names (such as \code{multi}, \code{ordinal}, \code{count},
\code{event}, and \code{LL}) are not included. Ignored if \code{IncludeCustom == FALSE}.}
}
\value{
A character vector containing the names of Observations
}
\description{
This function lists the names of Observations in a given \code{PMLModels} class
instance.
}
\examples{
PMLParametersSets <-
  create_ModelPK(
    Absorption = c("First-Order", "Gamma"),
    EliminationCpt = c(TRUE, FALSE))
list_Observations(PMLParametersSets)

}
\seealso{
\code{\link[=Observation]{Observation()}} \code{\link[=modify_Observation]{modify_Observation()}} \code{\link[=remove_Observation]{remove_Observation()}}
}
