% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelBuilderUI.R
\name{modelBuilderUI}
\alias{modelBuilderUI}
\title{Build RsNLME model from Shiny GUI and generate corresponding RsNLME code}
\usage{
modelBuilderUI(
  data,
  modelName = "PKPDmodel",
  workingDir = "",
  baseModel = NULL
)
}
\arguments{
\item{data}{Input dataset.}

\item{modelName}{Name of the model; if \code{missing}, named as 'PKPDmodel.'}

\item{workingDir}{Working directory to run the model. Current working directory 
will be used if \code{workingDir} not specified or does not exist.}

\item{baseModel}{The model object from where the input dataset and model name are recovered if 
arguments \code{data} and \code{modelName} are not specified.}
}
\value{
A model object of class \code{NlmePmlModel}
}
\description{
Shiny application to build RsNLME model from Shiny GUI and generate corresponding RsNLME code 
based on input selections.
}
\examples{
if (interactive()) {
model <- modelBuilderUI(data = Certara.RsNLME::pkData, modelName = "PK_Model")
}
 
}
