% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimpleNlmeJob.R
\name{print.SimpleNlmeJob}
\alias{print.SimpleNlmeJob}
\title{Print generic for class Simple.NlmeJob}
\usage{
\method{print}{SimpleNlmeJob}(x, ...)
}
\arguments{
\item{x}{Handle to an NLME job}

\item{...}{Arguments passed to methods.}
}
\value{
\code{NULL}
}
\description{
Reads progress file and prints out its contents.
Applicable to remote jobs or jobs running in backgroud.
}
\examples{
\dontrun{
model <- pkmodel(
  parameterization = "Clearance",
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  workingDir = tempdir()
  )
 host <- hostParams(sharedDirectory = tempdir(),
                    parallelMethod = "None",
                    hostName = "local",
                    numCores = 1)
if (.Platform$OS.type == "unix") {
# background is not supported on Windows
  job <- fitmodel(model,
                  numIterations = 3,
                  hostPlatform = host,
                  runrunInBackground = TRUE)
  print(job)
}
}
}
\keyword{internal}
