% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chile_cpi.R
\name{get_chile_cpi}
\alias{get_chile_cpi}
\title{Get Chile's Consumer Price Index (2010 = 100) from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/FP.CPI.TOTL}
}
\usage{
get_chile_cpi()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Consumer price index (2010 = 100)")
  \item \code{country}: Country name ("Chile")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Consumer Price Index (numeric, base year 2010 = 100)
}
}
\description{
Retrieves Chile's Consumer Price Index (CPI), with 2010 as the base year (index = 100),
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{FP.CPI.TOTL}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_chile_cpi()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
