/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCriteriaCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.utils.CriteriaNameHelper;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.ConditionEra;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.Death;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DoseEra;
import org.ohdsi.circe.cohortdefinition.DrugEra;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.ObservationPeriod;
import org.ohdsi.circe.cohortdefinition.PayerPlanPeriod;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.VisitDetail;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;

public class DuplicatesCriteriaCheck
extends BaseCriteriaCheck {
    private static final String DUPLICATE_WARNING = "Probably %s duplicates %s";
    private List<Pair<String, Criteria>> criteriaList = new ArrayList<Pair<String, Criteria>>();

    @Override
    protected void afterCheck(WarningReporter reporter, CohortExpression expression) {
        if (this.criteriaList.size() > 1) {
            for (int i = 0; i <= this.criteriaList.size() - 2; ++i) {
                Pair<String, Criteria> criteria = this.criteriaList.get(i);
                List duplicates = this.criteriaList.subList(i + 1, this.criteriaList.size()).stream().filter(pair -> this.compareCriteria((Criteria)criteria.getRight(), (Criteria)pair.getRight())).collect(Collectors.toList());
                if (duplicates.isEmpty()) continue;
                String names = duplicates.stream().map(Pair::getLeft).collect(Collectors.joining(", "));
                reporter.add(DUPLICATE_WARNING, criteria.getLeft(), names);
            }
        }
    }

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    private boolean compareCriteria(Criteria c1, Criteria c2) {
        if (Objects.equals(c1.getClass(), c2.getClass())) {
            if (c1 instanceof ConditionEra) {
                ConditionEra era1 = (ConditionEra)c1;
                ConditionEra era2 = (ConditionEra)c2;
                return new EqualsBuilder().append((Object)era1.codesetId, (Object)era2.codesetId).build();
            }
            if (c1 instanceof ConditionOccurrence) {
                ConditionOccurrence co1 = (ConditionOccurrence)c1;
                ConditionOccurrence co2 = (ConditionOccurrence)c2;
                return new EqualsBuilder().append((Object)co1.codesetId, (Object)co2.codesetId).append((Object)co1.conditionSourceConcept, (Object)co2.conditionSourceConcept).build();
            }
            if (c1 instanceof Death) {
                Death death1 = (Death)c1;
                Death death2 = (Death)c2;
                return new EqualsBuilder().append((Object)death1.codesetId, (Object)death2.codesetId).build();
            }
            if (c1 instanceof DeviceExposure) {
                DeviceExposure e1 = (DeviceExposure)c1;
                DeviceExposure e2 = (DeviceExposure)c2;
                return new EqualsBuilder().append((Object)e1.codesetId, (Object)e2.codesetId).build();
            }
            if (c1 instanceof DoseEra) {
                DoseEra d1 = (DoseEra)c1;
                DoseEra d2 = (DoseEra)c2;
                return new EqualsBuilder().append((Object)d1.codesetId, (Object)d2.codesetId).build();
            }
            if (c1 instanceof DrugEra) {
                DrugEra drug1 = (DrugEra)c1;
                DrugEra drug2 = (DrugEra)c2;
                return new EqualsBuilder().append((Object)drug1.codesetId, (Object)drug2.codesetId).build();
            }
            if (c1 instanceof DrugExposure) {
                DrugExposure de1 = (DrugExposure)c1;
                DrugExposure de2 = (DrugExposure)c2;
                return new EqualsBuilder().append((Object)de1.codesetId, (Object)de2.codesetId).build();
            }
            if (c1 instanceof Measurement) {
                Measurement m1 = (Measurement)c1;
                Measurement m2 = (Measurement)c2;
                return new EqualsBuilder().append((Object)m1.codesetId, (Object)m2.codesetId).build();
            }
            if (c1 instanceof Observation) {
                Observation o1 = (Observation)c1;
                Observation o2 = (Observation)c2;
                return new EqualsBuilder().append((Object)o1.codesetId, (Object)o2.codesetId).build();
            }
            if (c1 instanceof ObservationPeriod) {
                ObservationPeriod op1 = (ObservationPeriod)c1;
                ObservationPeriod op2 = (ObservationPeriod)c2;
                return new EqualsBuilder().setTestRecursive(true).append((Object)op1.periodStartDate, (Object)op2.periodStartDate).append((Object)op1.periodEndDate, (Object)op2.periodEndDate).append((Object)op1.periodLength, (Object)op2.periodLength).build();
            }
            if (c1 instanceof ProcedureOccurrence) {
                ProcedureOccurrence p1 = (ProcedureOccurrence)c1;
                ProcedureOccurrence p2 = (ProcedureOccurrence)c2;
                return new EqualsBuilder().append((Object)p1.codesetId, (Object)p2.codesetId).build();
            }
            if (c1 instanceof Specimen) {
                Specimen s1 = (Specimen)c1;
                Specimen s2 = (Specimen)c2;
                return new EqualsBuilder().append((Object)s1.codesetId, (Object)s2.codesetId).build();
            }
            if (c1 instanceof VisitOccurrence) {
                VisitOccurrence vo1 = (VisitOccurrence)c1;
                VisitOccurrence vo2 = (VisitOccurrence)c2;
                return new EqualsBuilder().append((Object)vo1.codesetId, (Object)vo2.codesetId).build();
            }
            if (c1 instanceof VisitDetail) {
                VisitDetail vd1 = (VisitDetail)c1;
                VisitDetail vd2 = (VisitDetail)c2;
                return new EqualsBuilder().append((Object)vd1.codesetId, (Object)vd2.codesetId).build();
            }
            if (c1 instanceof PayerPlanPeriod) {
                PayerPlanPeriod p1 = (PayerPlanPeriod)c1;
                PayerPlanPeriod p2 = (PayerPlanPeriod)c2;
                return new EqualsBuilder().append((Object)p1.payerConcept, (Object)p2.payerConcept).append((Object)p1.payerSourceConcept, (Object)p2.payerSourceConcept).append((Object)p1.planConcept, (Object)p2.planConcept).append((Object)p1.planSourceConcept, (Object)p2.planSourceConcept).append((Object)p1.sponsorConcept, (Object)p2.sponsorConcept).append((Object)p1.sponsorSourceConcept, (Object)p2.sponsorSourceConcept).append((Object)p1.stopReasonConcept, (Object)p2.stopReasonConcept).append((Object)p1.stopReasonSourceConcept, (Object)p2.stopReasonSourceConcept).build();
            }
            return EqualsBuilder.reflectionEquals((Object)c1, (Object)c2, (boolean)false);
        }
        return false;
    }

    @Override
    protected void checkCriteria(Criteria criteria, String groupName, WarningReporter reporter) {
        String criteriaName = CriteriaNameHelper.getCriteriaName(criteria) + " criteria in " + groupName;
        this.criteriaList.add((Pair<String, Criteria>)new ImmutablePair((Object)criteriaName, (Object)criteria));
    }
}

