% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AA.R
\name{AA}
\alias{AA}
\title{Average-of-awards rule}
\usage{
AA(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the AA rule. If \code{name = TRUE}, the name of the function (AA) as a character string.
}
\description{
This function returns the awards vector assigned by the average-of-awards rule (AA) to a claims problem.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}.

A vector \eqn{x=(x_1,\dots,x_n)} is an awards vector for the claims problem \eqn{(E,d)} if \eqn{0\le x \le d}
and satisfies the balance requirement, that is, \eqn{\sum_{i=1}^{n}x_i=E}.
Let \eqn{X(E,d)} be the set of awards vectors for \eqn{(E,d)}.

The average-of-awards rule (AA) assigns to each claims problem \eqn{(E,d)}
the expectation of the uniform distribution defined over the set of awards vectors, that is,
the centroid of \eqn{X(E,d)}.

Let \eqn{\mu} be the \eqn{(n-1)}-dimensional Lebesgue measure and \eqn{V(E,d)=\mu (X(E,d))} be the
measure (volume) of the set of awards \eqn{X(E,d)}. The average-of-awards rule assigns to each claims problem \eqn{(E,d)} the awards vector given by:
\deqn{\text{AA}(E,d)=\frac{1}{V(E,d)}\int_{X(E,d)} x d\mu.}

The average-of-awards rule corresponds to the core-center solution of the associated coalitional (pessimistic) game.

The function AA is programmed with the algorithm of Mirás Calvo et al. (2024b), which is an improved version of the algorithm of Mirás Calvo et al. (2024a).
}
\examples{
E=10
d=c(2,4,7,8)
AA(E,d)
#The average-of-awards rule is self-dual: AA(E,d)=d-AA(D-E,d)
D=sum(d)
d-AA(D-E,d)
}
\references{
Gonzalez-Díaz, J. and Sánchez-Rodríguez, E. (2007). A natural selection from the core of a TU game: the core-center. International Journal of Game Theory 36(1), 27-46.

Mirás Calvo, M.A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2024a). An algorithm to compute the average-of-awards rule for claims problems with an application to
the allocation of CO\eqn{_2} emissions. Annals of Operations Research 336, 1435-1459.

Mirás Calvo, M.A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2024b). On properties of the set of awards vectors for a claims problem. TOP 32, 137-167.

Mirás Calvo, M.A., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2022). The average-of-awards rule for claims problems. Social Choice and Welfare 59, 863-888.
}
\seealso{
\link{allrules}, \link{axioms}, \link{CD}, \link{coalitionalgame},  \link{setofawards}, \link{volume}.
}
