% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APRO.R
\name{APRO}
\alias{APRO}
\title{Adjusted proportional rule}
\usage{
APRO(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the APRO rule. If \code{name = TRUE}, the name of the function (APRO) as a character string.
}
\description{
This function returns the awards vector assigned by the adjusted proportional rule (APRO) to a claims problem.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}. For each coalition \eqn{S\in 2^N}, let \eqn{d(S)=\sum_{j\in S}d_j}
 and \eqn{N\backslash S} be the complementary coalition of \eqn{S}.

The minimal right of claimant \eqn{i\in N} in \eqn{(E,d)} is whatever is left after every other claimant has received his claim, or 0 if that is not possible:
\deqn{m_i(E,d)=\max\{0,E-d(N\backslash\{i\})\},\ i=1,\dots,n.}
Let \eqn{m(E,d)=(m_1(E,d),\dots,m_n(E,d))} be the vector of minimal rights.

The adjusted proportional rule (APRO) first assigns to each claimant its minimal right, and then divides the remainder
of the endowment \eqn{E'=E-\sum_{i=1}^n m_i(E,d)}
proportionally with respect to the new claims. The vector of the new claims \eqn{d'} is determined by the minimum of the remainder and the lowered claims,
\eqn{d_i'=\min\{E-\sum_{j=1}^n m_j(E,d),d_i-m_i\},\  i=1,\dots,n}. Therefore,
\deqn{\text{APRO}(E,d)=m(E,d)+\text{PRO}(E',d').}

The adjusted proportional rule corresponds to the \eqn{\tau}-value of the associated (pessimistic) coalitional game.
}
\examples{
E=10
d=c(2,4,7,8)
APRO(E,d)
#The adjusted proportional rule is self-dual: APRO(E,d)=d-APRO(D-E,d)
D=sum(d)
d-APRO(D-E,d)
}
\references{
Curiel, I. J., Maschler, M., and Tijs, S. H. (1987). Bankruptcy games. Zeitschrift für operations research 31(5), A143-A159.

Mirás Calvo, M.Á., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2023). Refining the Lorenz‐ranking of rules for
claims problems on restricted domains. International Journal of Economic Theory 19(3), 526-558.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{axioms}, \link{CD}, \link{coalitionalgame}, \link{PRO}.
}
