% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume.R
\name{volume}
\alias{volume}
\title{Volume of the set of awards vectors}
\usage{
volume(E, d, real = TRUE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{real}{Logical parameter. By default, \code{real = TRUE}.}
}
\value{
The volume of the set of awards vectors. If \code{real = FALSE}, it returns the volume of the projection into the last coordinate.
}
\description{
This function computes the volume of the set of award vectors of a claims problem and the projected volume.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}.

A vector \eqn{x=(x_1,\dots,x_n)} is an awards vector for the claims problem \eqn{(E,d)} if \eqn{0\le x \le d}
and satisfies the balance requirement, that is, \eqn{\sum_{i=1}^{n}x_i=E}.
Let \eqn{X(E,d)} be the set of awards vectors for \eqn{(E,d)}.

Let \eqn{\mu} be the \eqn{(n-1)}-dimensional Lebesgue measure. We define by \eqn{V(E,d)=\mu (X(E,d))} the
measure (volume) of the set of awards \eqn{X(E,d)} and \eqn{\hat{V}(E,d)} the volume of the projection onto an (\eqn{n-1)}-dimensional space. 
\deqn{V(E,d)=\sqrt{n}\hat{V}(E,d).}

The function is programmed following the procedure explained in Mirás Calvo et al. (2024b).
}
\examples{
E=10
d=c(2,4,7,10)
volume(E,d)
#The volume function is a symmetric function.
D=sum(d)
volume(D-E,d)
}
\references{
Mirás Calvo, M.A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2024a). An algorithm to compute the average-of-awards rule for claims problems with an application to
the allocation of CO\eqn{_2} emissions. Annals of Operations Research, 336: 1435-1459.

Mirás Calvo, M.A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2024b). On properties of the set of awards vectors for a claims problem. TOP, 32: 137-167.
}
\seealso{
\link{setofawards}.
}
