% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAStringSetOPR.R
\name{DNAStringSetOPR}
\alias{DNAStringSetOPR}
\title{Curing of biological sequences}
\usage{
DNAStringSetOPR(SEQs, PrimerR)
}
\arguments{
\item{SEQs}{file with fasta format containing biological sequences that are to be cleaned.}

\item{PrimerR}{dnastring containing the reverse primer/vector sequences to be removed.}
}
\value{
clean biological sequences and visualization of the alignments
}
\description{
Curates biological sequences of primer reverse.This cleaning is required for techniques such as cDNA-AFLP.
}
\examples{
SEQs = readDNAStringSet(system.file("sequences","SeqInputOPR.fasta", package = "CleanBSequences"))
PrimerR= DNAString ("GACTGCGTACCATGC")
DNAStringSetOPR (SEQs,PrimerR)
}
\author{
Florencia I Pozzi, Silvina A. Felitti
}
