% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv20_poisson_fixed.R
\name{cv20_poisson_fixed}
\alias{cv20_poisson_fixed}
\title{Poisson Fixed Effect Model}
\usage{
cv20_poisson_fixed(data, residue_col, cleaning_event_col)
}
\arguments{
\item{data}{Data frame containing the data.}

\item{residue_col}{The name of the residue column.}

\item{cleaning_event_col}{The name of the cleaning event column.}
}
\value{
A data frame output with the fixed effect summary.
}
\description{
Fits a fixed effects Poisson model and returns a data frame with the summary. 
If the p-value is significant, then the corresponding cleaning event is significantly 
different from other cleaning events. For a stable cleaning process, we wish all  
p-values are not significant.
}
\examples{
fixed_effect_summary <- cv20_poisson_fixed(data = Eq_Mic, residue_col = "Mic", 
cleaning_event_col = "CleaningEvent")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
