% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv28_freeman_ppu.R
\name{cv28_freeman_ppu}
\alias{cv28_freeman_ppu}
\title{Calculate Ppu using Freeman's Transformation}
\usage{
cv28_freeman_ppu(data, residue_col, cleaning_event_col, usl_col)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{residue_col}{The name of the column in `data` containing residue or defect counts.}

\item{cleaning_event_col}{The name of the column in `data` used for grouping data by cleaning event.}

\item{usl_col}{The name of the column in `data` that contains the Upper Specification Limit (USL).}
}
\value{
A data frame with columns for the Method, Ppu, CI_Lower, and CI_Upper.
}
\description{
This function calculates the Process Performance Index (Ppu) using Freeman's transformation,
including a bootstrap method to estimate the confidence interval of Ppu.
}
\examples{
cv28_freeman_ppu(Eq_Mic, "Mic", "CleaningEvent", "USL")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
