% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv29_mic_ppu.R
\name{cv29_mic_ppu}
\alias{cv29_mic_ppu}
\title{Calculate Mic Ppu with Five Methods}
\usage{
cv29_mic_ppu(data, residue_col, cleaning_event_col, usl_col)
}
\arguments{
\item{data}{A dataframe containing the dataset.}

\item{residue_col}{The name of the column in `data` that contains the residue values.}

\item{cleaning_event_col}{The name of the column in `data` that contains the cleaning event identifiers.}

\item{usl_col}{The name of the column in `data` that contains the Upper Specification Limit values.}
}
\value{
A dataframe with the Ppu calculations for each method and the minimum Ppu method.
}
\description{
This function calculates the process performance index (Ppu) for Mic using five different methods,
including Q-Binomial, Q-Poisson, Anscombe, Freeman, and KDE. It returns a dataframe with the Ppu
values, lower and upper confidence intervals for each method, and appends a row for the method
with the minimum Ppu value.
}
\examples{
\donttest{
  MicPPU <- cv29_mic_ppu(Eq_Mic, "Mic", "CleaningEvent", "USL")
}
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
