% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelPlot.R
\name{PanelPlot}
\alias{PanelPlot}
\title{Plot Micro-Panel (longitudinal) Data}
\usage{
PanelPlot(
  data,
  formula = Y ~ Time,
  group = "ID",
  colour = NA,
  mean_traj_all = FALSE,
  mean_traj_group = FALSE,
  show_legend = TRUE,
  title = NULL,
  x_title = NULL,
  y_title = NULL
)
}
\arguments{
\item{data}{A data frame containing the variables named in \code{formula} and \code{group} arguments.}

\item{formula}{A two-sided \code{\link[stats]{formula}} object, with a numeric, clustering variable (Y) on the left of a ~ separator and the time (numeric) variable on the right. Time is measured from the start of the follow-up period (baseline).}

\item{group}{A grouping factor variable (vector), i.e. single identifier for each (trajectory).}

\item{colour}{Character, which is a variable's name in data. The trajectories are distinguished by colour according to this variable.}

\item{mean_traj_all}{Logical scalar. It indicates whether to show mean overall trajectory. Default is \emph{FALSE}.}

\item{mean_traj_group}{Logical scalar. It indicates whether to show mean trajectory by group. Default is \emph{FALSE}.}

\item{show_legend}{Logical scalar. It indicates whether to show cluster legend. Default is \emph{TRUE}.}

\item{title}{String. Is an optional title for a plot. Otherwise no title will used.}

\item{x_title}{String. Is an optional title for x axis. Otherwise variable name after ~ in \code{formula} will used.}

\item{y_title}{String. Is an optional title for y axis. Otherwise variable name before ~ in \code{formula} will used.}
}
\value{
Returns plot using package ggplot2.
}
\description{
This function plots micro-panel (longitudinal) data from stored \code{\link[base]{data.frame}} or randomly generated panel data from \code{\link{GeneratePanel}} function.
}
\examples{
set.seed(123)
dataMale <- GeneratePanel(n = 50, Param = ParamLinear, NbVisit = 10)
dataMale$Gender <- "M"
dataFemale <- GeneratePanel(n = 50, Param = ParamLinear, NbVisit = 10)
dataFemale$ID <- dataFemale$ID + 50
dataFemale$Gender <- "F"
data <- rbind(dataMale, dataFemale)

PanelPlot(data = data, formula = Y ~ Time, group = "ID", colour = "Gender")
PanelPlot(data = data, formula = Y ~ Time, group = "ID", colour = "Gender", mean_traj_all = TRUE)
PanelPlot(data = data, formula = Y ~ Time, group = "ID", colour = "Gender", mean_traj_group = TRUE)
}
\keyword{CLUMP}
