% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icp.torus.R, R/methods.R
\name{icp.torus}
\alias{icp.torus}
\alias{logLik.icp.torus}
\alias{predict.icp.torus}
\alias{plot.icp.torus}
\title{Conformity score for inductive prediction sets}
\usage{
icp.torus(
  data,
  split.id = NULL,
  model = c("kmeans", "kde", "mixture"),
  mixturefitmethod = c("axis-aligned", "circular", "general"),
  kmeansfitmethod = c("general", "homogeneous-circular", "heterogeneous-circular",
    "ellipsoids"),
  init = c("hierarchical", "kmeans"),
  d = NULL,
  additional.condition = TRUE,
  J = 4,
  concentration = 25,
  kmax = 500,
  THRESHOLD = 1e-10,
  maxiter = 200,
  verbose = TRUE,
  ...
)

\method{logLik}{icp.torus}(object, ...)

\method{predict}{icp.torus}(object, newdata, ...)

\method{plot}{icp.torus}(
  x,
  data = NULL,
  level = 0.1,
  ellipse = TRUE,
  out = FALSE,
  type = NULL,
  ...
)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}
or \eqn{[-\pi, \pi)^d}. Default is \code{NULL}.}

\item{split.id}{a n-dimensional vector consisting of values 1 (estimation)
and 2(evaluation)}

\item{model}{A string. One of "kde", "mixture", and "kmeans" which
determines the model or estimation methods. If "kde", the model is based
on the kernel density estimates. It supports the kde-based conformity score
only. If "mixture", the model is based on the von Mises mixture, fitted
with an EM algorithm. It supports the von Mises mixture and its variants
based conformity scores. If "kmeans", the model is also based on the von
Mises mixture, but the parameter estimation is implemented with the
elliptical k-means algorithm illustrated in Appendix. It supports the
log-max-mixture based conformity score only. If the
dimension of data space is greater than 2, only "kmeans" is supported.
Default is \code{model = "kmeans"}.}

\item{mixturefitmethod}{A string. One of "circular", "axis-aligned", and
"general" which determines the constraint of the EM fitting. Default is
"axis-aligned". This argument only works for \code{model = "mixture"}.}

\item{kmeansfitmethod}{A string. One of "general", ellipsoids",
"heterogeneous-circular" or "homogeneous-circular". If "general", the
elliptical k-means algorithm with no constraint is used. If "ellipsoids",
only the one iteration of the algorithm is used. If"heterogeneous-circular",
the same as above, but with the constraint that ellipsoids must be spheres.
If "homogeneous-circular", the same as above but the radii of the spheres are
identical. Default is "general". This argument only works for \code{model = "kmeans"}.}

\item{init}{Methods for choosing initial values of "kmeans" fitting.
 Must be "hierarchical" or "kmeans". If "hierarchical", the initial
parameters are obtained with hierarchical clustering method.
If "kmeans", the initial parameters are obtained with extrinsic k-means method.
 Additional arguments for k-means clustering and hierarchical clustering can be designated
 via argument \code{...}. If no options are designated, \code{nstart=1} for \code{init="kmeans"}
 and \code{method="complete"} for \code{init="hierarchical"} are used. Default is "hierarchical".}

\item{d}{pairwise distance matrix(\code{dist} object) for \code{init = "hierarchical"},
which used in hierarchical clustering. If \code{init = "hierarchical"} and \code{d = NULL},
\code{d} will be automatically filled with \code{ang.pdist(data)}.}

\item{additional.condition}{boolean index.
If \code{TRUE}, a singular matrix will be altered to the scaled identity.}

\item{J}{A scalar or numeric vector for the number(s) of components for \code{model = c("mixture", "kmeans")}.
Default is \code{J = 4}.}

\item{concentration}{A scalar or numeric vector for the concentration parameter(s) for \code{model = "kde"}.
Default is \code{concentration = 25}.}

\item{kmax}{the maximal number of kappa. If estimated kappa is
larger than \code{kmax}, then put kappa as \code{kmax}.}

\item{THRESHOLD}{number for difference between updating and
updated parameters. Default is 1e-10.}

\item{maxiter}{the maximal number of iteration. Default is 200.}

\item{verbose}{boolean index, which indicates whether display
additional details as to what the algorithm is doing or
how many loops are done. Moreover, if \code{additional.condition} is
\code{TRUE}, the warning message will be reported.}

\item{...}{additional parameters. For plotting icp.torus, these parameters are for ggplot2::ggplot().}

\item{object}{\code{icp.torus} object}

\item{newdata}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}.
Dimension d must be the same as data used for \code{icp.torus} object.}

\item{x}{\code{icp.torus} object}

\item{level}{either a numeric scalar or a vector in \eqn{[0,1]}. Default value is 0.1.}

\item{ellipse}{A boolean index which determines whether plotting ellipses from
mixture models. Default is \code{TRUE}. (This option is used only when the
\code{icp.torus} object \code{x} is fitted by model \code{kmeans} or \code{mixture}.)}

\item{out}{An option for returning the ggplot object. Default is \code{FALSE}.}

\item{type}{A string. One of "mix", "max" or "e". This argument is only available if \code{icp.torus}
object is fitted with \code{model = "mixture"}. Default is \code{NULL}. If \code{type != NULL}, argument
\code{ellipse} automatically becomes \code{FALSE}. If "mix", it plots based on von Mises mixture.
If "max", it plots based on von Mises max-mixture. If "e", it plots based on ellipse-approximation.}
}
\value{
\code{icp.torus} returns an \code{icp.torus} object, containing all values
  to compute the conformity score (if \code{J} or \code{concentration} is a
  single value). if \code{J} or \code{concentration} is a vector containing
  multiple values, then \code{icp.torus} returns a list of \code{icp.torus} objects
}
\description{
\code{icp.torus} prepares all values
  for computing the conformity score for specified methods.

\code{plot.icp.torus} plots \code{icp.torus} object with some options.
}
\examples{
\donttest{
data <- toydata1[, 1:2]

icp.torus <- icp.torus(data, model = "kmeans",
                       kmeansfitmethod = "general",
                       J = 4, concentration = 25)
}
}
\references{
Jung, S., Park, K., & Kim, B. (2021). Clustering on the torus by conformal prediction. \emph{The Annals of Applied Statistics}, 15(4), 1583-1603.

  Mardia, K. V., Kent, J. T., Zhang, Z., Taylor, C. C., & Hamelryck, T. (2012). Mixtures of concentrated multivariate sine distributions with applications to bioinformatics. \emph{Journal of Applied Statistics}, 39(11), 2475-2492.

  Di Marzio, M., Panzera, A., & Taylor, C. C. (2011). Kernel density estimation on the torus. \emph{Journal of Statistical Planning and Inference}, 141(6), 2156-2173.

  Shin, J., Rinaldo, A., & Wasserman, L. (2019). Predictive clustering. \emph{arXiv preprint arXiv:1903.08125}.
}
