% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.torus.R
\name{kde.torus}
\alias{kde.torus}
\title{Kernel density estimation using circular von Mises distribution}
\usage{
kde.torus(data, eval.point = NULL, concentration = 25)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}}

\item{eval.point}{N x N numeric matrix on \eqn{[0, 2\pi)^d}. Default input is
\code{NULL}, which represents the fine grid points on \eqn{[0, 2\pi)^d}.}

\item{concentration}{positive number which has the role of \eqn{\kappa} of
von Mises distribution. Default value is 25.}
}
\value{
\code{kde.torus} returns N-dimensional vector of kdes evaluated at eval.point
}
\description{
\code{kde.torus} returns a kde using independent multivariate von mises kernel.
}
\examples{
data <- ILE[1:200, 1:2]

kde.torus(data)
}
\references{
Jung, S., Park, K., & Kim, B. (2021). Clustering on the torus by conformal prediction. \emph{The Annals of Applied Statistics}, 15(4), 1583-1603.

  Di Marzio, M., Panzera, A., & Taylor, C. C. (2011). Kernel density estimation on the torus. \emph{Journal of Statistical Planning and Inference}, 141(6), 2156-2173.
}
\seealso{
\code{\link{grid.torus}}
}
