% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emm.R
\name{emm}
\alias{emm}
\title{Calculate estimated marginal means for a cluster bootstrap GLM}
\usage{
emm(object, confint.level = 0.95)
}
\arguments{
\item{object}{object of class \code{clusbootglm}.}

\item{confint.level}{level of the confidence interval.}
}
\value{
\code{emm} returns an object of class \code{clusbootemm}, containing the following components:
\item{grid}{Grid with estimated marginal means for each combination of levels of the variables.}
\item{bootstrapsample.emm}{p*B matrix, with p being the number of estimates and B being the number of bootstrap samples.}
}
\description{
Returns the estimated marginal means of a \code{clusbootglm} object.
This function works with a maximum of one between-subjects and one within-subjects variable.
}
\examples{
\dontrun{
medication <- medication[medication$time \%\% 1 == 0,]
medication$time_f <- as.factor(medication$time)
set.seed(1)
model.1 <- clusbootglm(pos~time_f*treat, clusterid = id, data = medication)
emm.1 <- emm(object = model.1)
summary(object = emm.1)}
}
\author{
Mathijs Deen
}
