% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Balance.R
\name{Balance}
\alias{Balance}
\title{Calculating the balance of the FBM model}
\usage{
Balance(A, especieI, especie, E, EspecieMaxima)
}
\arguments{
\item{A}{Number of time points for which we calculate the balance}

\item{especieI}{Number. The bacteria that we do not include in the balance. We must write the number of the row in which the bacteria is placed in the matrix \code{especie}.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{E}{Number of bacteria available}

\item{EspecieMaxima}{Row in which the bacteria chosen as reference is in \code{especie}.This bacteria is used as reference in the alr tranformation that the model does and it is placed at the denominator of the balance)}
}
\value{
Returns a vector with the value of the balance for all the time points indicated.
}
\description{
Defining a balance where we compare all the bacteria (except the one chosen as reference and the \code{especieI}) with the one chosen as reference.
}
\examples{

Balance(2,2,cbind(c(0.1,0.1,0.8),c(0.2,0.1,0.7)),3,3)

}
