% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpectedValuess_BPBM.R
\name{ExpectedValuess_BPBM}
\alias{ExpectedValuess_BPBM}
\title{Obtainig the value of the dirichlet parameters, the expected value and the variance.}
\usage{
ExpectedValuess_BPBM(Estimated.Param, MatrizPBmodelo, E, Tt)
}
\arguments{
\item{Estimated.Param}{Vector with the estimate parameters. Column "mean" of the output of "StudyingParam" function.}

\item{MatrizPBmodelo}{Matrix. Output of "ObtainingValueSPBal" called "MatrixSPBal".}

\item{E}{Number of bacteria available.}

\item{Tt}{Number of time points available.}
}
\value{
Returns a list with:

\itemize{
  \item Dirichlet.Param:  Matrix. Matrix that contains at row i the dirichlet parameter of the bacteria i at all time points.
  \item Expected.Value:  Matrix. Matrix that contains at row i the expected value of the bacteria i at all time points. The bacterias are placed at the same orden than in \code{especies}.
   \item Variance.Value:  Matrix. Matrix that contains at row i the variance of the bacteria i at all time points. The bacterias are placed at the same orden than in \code{especies}.
  }
}
\description{
This function calculates the value of the dirichlet parameters, the expected value and the variance for the BPBM model.
}
\details{
The regression of this model is defined by:


\deqn{\mu_{it}=a_{i0}+a_{i1}\cdot\text{SPBal}_{1,t-1}+\cdots+a_{iM}\cdot\text{SPBal}_{M,t-1}}
}
\examples{

Tt=3
E=3
Estimated.Param=c(0.1 ,0.4, 0.7, 0.2 ,0.5, 0.8 ,0.3, 0.6, 0.9,
                 0.1, 0.4 ,0.7, 0.2, 0.5, 0.8, 0.3 ,0.6, 0.9)
MatrizPBmodelo=rbind(c(1,1,1),c(0.3,0.6,-0.1),c(0.2,-0.4,0.3))
ExpectedValuess_BPBM(Estimated.Param,MatrizPBmodelo,E,Tt)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
