% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaxBacteriaPred.R
\name{MaxBacteriaPred}
\alias{MaxBacteriaPred}
\title{Putting the reference bacteria at the last row}
\usage{
MaxBacteriaPred(
  nombresOriginal,
  especieOriginal,
  E,
  Tt,
  Pred,
  K,
  especieOriginal.All,
  which.esp
)
}
\arguments{
\item{nombresOriginal}{Vector with the bacterial names at the same order than in DaTa. it must be fulfilled that lenght(nombresOriginal)==dim(DaTa)[2]-1}

\item{especieOriginal}{Matrix that contains at row i the bacterial taxa of bacteria i at t=1,2,...,\code{Tt}, with \code{Tt}=Pred-1.}

\item{E}{Number of bacteria available}

\item{Tt}{Number of time points used to estimate the model (\code{Tt}=Pred-1)}

\item{Pred}{Number. The data at t=1,...,Pred-1 will be used to estimate the model. The rest of the time points will be used to study the capacity of the model to predict. If \code{Pred==0} all the datatset will be used to estimate the model.}

\item{K}{Number of time points at the data}

\item{especieOriginal.All}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{which.esp}{If \code{which=="Max"} this function puts in the last position of the matrix the bacteria with maximum mean abundance.  If \code{which=="Min"} this function puts in the last position of the matrix the bacteria with minimum mean abundance.  If which is equal to a number this function puts in the last position of the matrix the bacteria that is in the "which" row of the \code{especieOriginal} matrix.}
}
\value{
Returns a list with
\itemize{
  \item \code{especie} - Matrix that contains at row i the bacterial taxa of bacteria i at time points t=1,2,...,\code{Tt} but  the bacteria with with maximum (or minimum) mean abundance (or the bacteria indicated by the user) is placed at the last row.
  \item \code{especiemodi} - Matrix that contains at row i the bacterial taxa of bacteria i at time points t=2,...,\code{Tt} but  the bacteria with with maximum (or minimum) mean abundance (or the bacteria indicated by the user) is placed at the last row.
   \item \code{nombres} - Vector with the bacteria's names placed in the order in which appear in the rows of the matrices \code{especie} and \code{especiemodi}
  \item \code{EE}  -  Row in which the bacterial with maximum (or minimum) mean abundance was (or the value of "which" if which is numerical).
   \item  \code{EspecieMaxima} - Row in which the bacterial with with maximum (or minimum) mean abundance (or the bacteria indicated by the user) is in \code{especie}.)
#' #'   \item \code{especie.all}  - Matrix that contains at row i the bacterial taxa of bacteria i at all time points (t=1,2,...,K) but  the bacteria with with maximum (or minimum) mean abundance (or the bacteria indicated by the user) is placed at the last row.
   \item  \code{especiemodi.all} - Matrix that contains at row i the bacterial taxa of bacteria i at all time points (t=2,...,K) but  the bacteria with with maximum (or minimum) mean abundance (or the bacteria indicated by the user) is placed at the last row.


}
}
\description{
This function calculates the mean abundance of each bacteria taking into account the time points used to estimate the model (t=1,2,...,\code{Tt}). Then, it creates a matrix where each row contains the abundance of one bacteria at all time points but  the bacteria with maximum (or minimum) mean abundance (or the bacterial indicated by the user) is placed at the last row
}
\examples{

names2=c("Bact1","Bact2","Bact3","Bact4","Bact5")
set.seed(314)
esp2=t(gtools::rdirichlet(n=6, c(1,1,5,1,1)))
e2=5

MaxBacteriaPred(names2,esp2[,-c(4,5,6)],e2,3,Pred=4, 6,esp2, "Max")

}
