% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNI_functions.R
\name{plotPcorvsCor}
\alias{plotPcorvsCor}
\title{Correlation vs Partial correlation}
\usage{
plotPcorvsCor(
  ResultsCoNI,
  edgeFeature,
  vertexD,
  edgeD,
  vertexFeatures = NULL,
  outputDir = "./",
  fname,
  label_edgeFeature = "Edge Feature",
  plot_to_screen = TRUE,
  height = 10,
  width = 8,
  saveFiles = FALSE
)
}
\arguments{
\item{ResultsCoNI}{The significant results generated by CoNI}

\item{edgeFeature}{The edge feature to explore e.g. Fabp2 (for a gene)}

\item{vertexD}{Vertex data that was given as input to CoNI}

\item{edgeD}{Edge data that was given as input to CoNI}

\item{vertexFeatures}{The vertex features to include as a list. If not specified all metabolites available in combination with the edgeFeature will be used}

\item{outputDir}{Output directory with path}

\item{fname}{File name to save the plots}

\item{label_edgeFeature}{Name for plot title e.g. Gene or Protein}

\item{plot_to_screen}{logical. If TRUE plots will be outputted to the plotting screen}

\item{height}{height of the plotting area for the saved file}

\item{width}{width of the plotting are for the saved file}

\item{saveFiles}{logical. If FALSE plot is not saved to disk}
}
\value{
Returns a ggplot object for a scatter plot with two regression lines.
The blue line is the regression of the vertex features, and the red line is the regression
of the resulting residuals after regressing each vertex feature with the edge feature.
The slope of the blue line corresponds to the pearson correlation coefficient and the slope of the red line
to the partial correlation coefficient
}
\description{
This function fits two linear models on standardize data and plots the results. It generates a scatter plot with two regression lines, where the slopes correspond to the correlation and partial correlation coefficients (blue for cor and red for pcor)
}
\examples{
#Load gene expression - Toy dataset of two treatments
data(GeneExpToy)
#Samples in rows and genes in columns
GeneExp <- as.data.frame(t(GeneExpToy))
hfd_gene <- GeneExp[1:8,] #high fat diet
chow_gene<- GeneExp[9:nrow(GeneExp),] #chow diet

#Load metabolite expression - Toy dataset of two treatments
data(MetaboExpToy)
MetaboExp <- MetaboExpToy
hfd_metabo <- MetaboExp[11:18,] #high fat diet
chow_metabo <- MetaboExp[1:10,] #chow diet

#Match row names both data sets
rownames(hfd_metabo)<-rownames(hfd_gene)
rownames(chow_metabo)<-rownames(chow_gene)

#Load CoNI results
data(CoNIResultsHFDToy)

plotPcorvsCor(ResultsCoNI = CoNIResultsHFDToy,
              edgeFeature = "Arfrp1",
              vertexFeatures = c("PC.ae.C40.2", "SM..OH..C22.1"),
              vertexD = hfd_metabo,
              edgeD = hfd_gene,
              label_edgeFeature = "Gene",
              plot_to_screen = TRUE,
              height = 10,
              saveFiles = FALSE)
}
