% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codesInUse.R
\name{codesInUse}
\alias{codesInUse}
\title{Get the concepts being used in patient records}
\usage{
codesInUse(
  cdm,
  minimumCount = 0L,
  table = c("condition_occurrence", "device_exposure", "drug_exposure", "measurement",
    "observation", "procedure_occurrence", "visit_occurrence")
)
}
\arguments{
\item{cdm}{A cdm reference via CDMConnector.}

\item{minimumCount}{Any codes with a frequency under this will be removed.}

\item{table}{cdm table of interest.}
}
\value{
A list of integers indicating codes being used in the database.
}
\description{
Get the concepts being used in patient records
}
\examples{
\donttest{
cdm <- mockVocabRef("database")
x <- codesInUse(cdm = cdm)
x
CDMConnector::cdmDisconnect(cdm)
}
}
