% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TemplateImplementations.R
\name{createAtcCohortTemplateDefinition}
\alias{createAtcCohortTemplateDefinition}
\title{Create ATC Cohort Template Definition}
\usage{
createAtcCohortTemplateDefinition(
  connection,
  identifierExpression = "CAST(concept_id as bigint) * 1000",
  cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cohortDatabaseSchema,
  nameSuffix = "",
  mergeIngredientEras = TRUE,
  priorObservationPeriod = 365,
  vocabularyDatabaseSchema = cdmDatabaseSchema
)
}
\arguments{
\item{connection}{Database connection object}

\item{identifierExpression}{An expression for setting the cohort id for the resulting cohort. Must produce unique ids}

\item{cdmDatabaseSchema}{CDM database schema}

\item{tempEmulationSchema}{Temporary emulation schema}

\item{cohortDatabaseSchema}{Cohort database schema}

\item{nameSuffix}{A name suffix to use to add to the cohort names - this is useful if you're using multiple
parameterized versions of this definition}

\item{mergeIngredientEras}{(optional) Boolean indicating if different ingredients under the same ATC code should be merged}

\item{priorObservationPeriod}{(optional) Required prior observation period for individuals}

\item{vocabularyDatabaseSchema}{Vocabulary database schema}
}
\value{
A CohortTemplateDefinition instance
}
\description{
Template cohort definition for all ATC level 4 class exposures. The cohortId = conceptId * 1000 + 4.
The "identifierExpression" can be customized for uniqueness.
}
