% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TemplateImplementations.R
\name{createSnomedCohortTemplateDefinition}
\alias{createSnomedCohortTemplateDefinition}
\title{Create SNOMED Cohort Template Definition}
\usage{
createSnomedCohortTemplateDefinition(
  connection,
  identifierExpression = "CAST(concept_id as bigint) * 1000",
  cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  priorObservationPeriod = 365,
  requireSecondDiagnosis = FALSE,
  nameSuffix = "",
  vocabularyDatabaseSchema = cdmDatabaseSchema
)
}
\arguments{
\item{connection}{Database connection object}

\item{identifierExpression}{An expression for setting the cohort id for the resulting cohort. Must produce unique ids}

\item{cdmDatabaseSchema}{CDM database schema}

\item{tempEmulationSchema}{Temporary emulation schema}

\item{priorObservationPeriod}{(optional) Required prior observation period for individuals}

\item{requireSecondDiagnosis}{(optional) Require more than one diagnosis code}

\item{nameSuffix}{A name suffix to use to add to the cohort names - this is useful if you're using multiple
parameterized versions of this definition}

\item{vocabularyDatabaseSchema}{Vocabulary database schema}
}
\value{
A CohortTemplateDefinition instance
}
\description{
Template cohort definition for all OHDSI standard conditions. The cohortId = conceptId * 1000.
The "identifierExpression" can be customized for uniqueness.
This definition uses any valid SNOMED condition code and all its descendants.

Excluded terms include word patterns:

  '%finding', 'disorder of%', 'finding of%', 'disease of%' 'injury of%' '%by site' '%by body site' '%by mechanism'
   '%of body region' '%of anatomical site' '%of specific body structure%'

Cohorts are first event.
}
