% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Tulua_Public_Schools_tbl_df}
\alias{Tulua_Public_Schools_tbl_df}
\title{Tulua Public Schools Information}
\format{
A tibble with 105 observations and 8 variables:
\describe{
  \item{COD_DANE_INS}{Numeric code representing the educational institution's DANE code.}
  \item{INSTITUCION}{Character string representing the name of the public school.}
  \item{SEDE}{Character string representing the name of the specific school location or branch.}
  \item{COD_DANE_SEDE}{Numeric code representing the DANE code of the specific school branch.}
  \item{TELEFONO}{Character string representing the phone number of the school.}
  \item{CORREOS}{Character string representing the email addresses of the school.}
  \item{DIRECCIÓN}{Character string representing the physical address of the school.}
  \item{CORDE_GEO}{Character string representing the geographical coordinates of the school.}
}
}
\source{
Originally taken from GOV.CO, url: https://www.datos.gov.co/Educaci-n/Listado-de-colegios-p-blicos-del-municipio-de-Tulu/scz9-f8ud/about_data
}
\usage{
data(Tulua_Public_Schools_tbl_df)
}
\description{
This dataset, Tulua_Public_Schools_tbl_df, is a tibble containing detailed information about public schools
located in the municipality of Tulua, Valle del Cauca, Colombia. It includes the name, location, contact information,
and the geographical coordinates of each institution, as well as specific details about each school and its facilities.
}
\details{
The dataset name has been kept as Tulua_Public_Schools_tbl_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ColombiAPI package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
