% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CombS.R
\name{CombS}
\alias{CombS}
\title{The Combinatory Method (s) for the construction of rectangular PBIB designs}
\usage{
CombS(n, l, s)
}
\arguments{
\item{n}{Number of lines of the association schemes array.}

\item{l}{Number of columns of the association schemes array.}

\item{s}{Number of the token treatments from the same row of the association scheme.}
}
\value{
A LIST :
 \itemize{
  \item \code{PBIB } The configuration of the PBIB.
  \item \code{Type } The type of the design
  \item \code{V } Number of treatments.
  \item \code{B } Number of blocs.
  \item \code{R } Repetition of each treatment.
  \item \code{K } Size of blocs.
  \item \code{lamda } Vector of m-lambda.
  \item \code{Resolvable } Is the design Resolvable ?
  }
}
\description{
The application of the Combinatory Method (s), with \eqn{s} chosen in \eqn{[2, l-1]},
on rectangular association scheme to obtain the configuration and the
parameters of the \code{PBIB} design associated.
}
\details{
\itemize{
         \item For \eqn{2 < s < l}, we obtain a rectangular PBIB design.
         \item For \eqn{s = l}, we obtain a singular group divisible designs.
 }
}
\examples{
\dontrun{
n<-3
l<-3
s<-2
CombS(l,n,s)
}
}
\references{
Imane Rezgui, Z. Gheribi-Aoulmi (2014). New construction method
of rectangular partially balanced incomplete block designs and
singular group divisible designs, Journal of Mathematics and Statistics, 10, 45- 48.

M.N. Vartak 1955. On an application of Kronecker product of Matrices to Statistical designs. Ann. Math. Stat.,26(420-438).
}
\seealso{
\code{\link{UType}}
}
\author{
Mohamed Laib, Imane Rezgui, Zebida Gheribi-Aoulmi and Herve Monod
}
