% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{simasd_covars}
\alias{simasd_covars}
\title{Simulated demographics dataset modeled of a subset of the preprocessed 
ABIDE database}
\format{
A dataframe with 49 rows and 8 columns:
\describe{
  \item{id}{a generic ID, an integer value}
  \item{dx_group}{diagnostic group (0=control, 1=Autism Spectrum Disorder (ASD)}
  \item{sex}{subject sex (0=male, 1=female)}
  \item{age}{subject age in years}
  \item{handedness}{subject handedness category, a factor with three level
    (0=right, 1=left, 2=ambidextrous)}
  \item{fullscale_IQ}{fullscale IQ score, simulated as if administered from the
    Wechsler Abbreviated Scales of Intelligence (WASI), an integer value in (50,160)}
  \item{verbal_IQ}{verbal IQ component, simulated as if administered from the
    Wechsler Abbreviated Scales of Intelligence (WASI), an integer value in (55,160)}
  \item{nonverbal_IQ}{nonverbal IQ component, simulated as if administered from the
    Wechsler Abbreviated Scales of Intelligence (WASI), an integer value in (53,160)}
}
}
\usage{
simasd_covars
}
\description{
A dataset of demographics generated based on summary statistics for a subset
of the ABIDE preprocessed database (http://preprocessed-connectomes-project.org/abide/).
The variables are as follows:
}
\keyword{datasets}
