% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upset.R
\name{upset_query}
\alias{upset_query}
\title{Highlight chosen sets or intersections}
\usage{
upset_query(
  set = NULL,
  intersect = NULL,
  group = NULL,
  only_components = NULL,
  ...
)
}
\arguments{
\item{set}{name of the set to highlight}

\item{intersect}{a vector of names for the intersection to highlight; pass \code{NA} to select the empty intersection}

\item{group}{name of the set to highlight when using \code{group_by='sets'}}

\item{only_components}{which components to modify; by default all eligible components will be modified; the available components are 'overall_sizes', 'intersections_matrix', 'Intersection size', and any annotations specified}

\item{...}{\itemize{
\item passed to geoms in modified components
}}
}
\description{
Highlight sets or intersections matching specified query.
}
\examples{
upset_query(intersect=c('Drama', 'Comedy'), color='red', fill='red')
upset_query(set='Drama', fill='blue')
}
