% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDH.R
\name{GetDH}
\alias{GetDH}
\title{Occurrence of compound dry-hot events}
\usage{
GetDH(mp,mt,threp,thret)
}
\arguments{
\item{mp}{Precipitation}

\item{mt}{Temperature}

\item{threp}{Threshold of precipitation (e.g., 20th percentile)}

\item{thret}{Threshold of temperature (e.g., 80th percentile)}
}
\value{
The occurrence of compound dry-hot events (0-1 binary variable)
}
\description{
Extract compound dry-hot (DH) occurrences based on thresholds of precipitation and temperature. The binary variable of the DH (or dry-warm) event can be obtained.
}
\examples{
mp=matrix(rnorm(20,0,1),ncol=1) # 20-year precipitation of a specific month (e.g., August)
mt=matrix(rnorm(20,0,1),ncol=1) # 20-year temperature of a specific month (e.g., August)
threp=20
thret=80
DH<-GetDH(mp,mt,threp,thret)
}
\references{
Hao, Z. et al. (2018). A multivariate approach for  statistical assessments of compound extremes. J. Hydrol., 565: 87-94.

Hao, Z. et al. (2019). A monitoring and prediction system for compound dry and hot events. Environ. Res. Lett., 14:114034.
}
