% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_funs.R
\name{error_concentration}
\alias{error_concentration}
\alias{error_efflux}
\alias{error_funs}
\alias{error_concentration.cfp_pfres}
\alias{error_concentration.cfp_fgres}
\alias{error_concentration.cfp_altres}
\alias{error_efflux.cfp_pfres}
\alias{error_efflux.cfp_fgres}
\alias{error_efflux.cfp_altres}
\title{Estimate model error}
\usage{
error_concentration(x, param_cols = NULL, normer = "sd")

\method{error_concentration}{cfp_pfres}(x, param_cols = NULL, normer = "sd")

\method{error_concentration}{cfp_fgres}(x, param_cols = NULL, normer = "sd")

\method{error_concentration}{cfp_altres}(x, param_cols = NULL, normer = "sd")

error_efflux(x, param_cols, EFFLUX, normer = "sd", ...)

\method{error_efflux}{cfp_pfres}(x, param_cols, EFFLUX, normer = "sd", ...)

\method{error_efflux}{cfp_fgres}(x, param_cols, EFFLUX, normer = "sd", ...)

\method{error_efflux}{cfp_altres}(x, param_cols, EFFLUX, normer = "sd", ...)
}
\arguments{
\item{x}{A cfp_pfres object, that is returned by a call to pro_flux()}

\item{param_cols}{The columns that, together, define different parameters
(e.g. different gases) for which NRMSEs should be calculated separately
(e.g. "gas"). Defaults to the id_cols of layers_map. If no such distinction
is wished, set to \code{character()}}

\item{normer}{a character string defining the type of
normalization to be applied. Can be one of
\describe{
\item{mean}{the arithmetic mean of a}
\item{sd}{the standard deviation of a (default).}
\item{range}{the difference between the range of a}
\item{IQR}{the difference between the interquantile range of a}
}}

\item{EFFLUX}{A data.frame with (at most) one value of efflux per profile of
x. Must contain any id_cols of x needed.}

\item{...}{Further arguments passed to \link{efflux}}
}
\value{
The calculated error estimate for a single model, a list of models
(\link{cfp_altres}) and for each parameter combination in \code{param_cols}
}
\description{
A set of functions that can be called on an cfp_pfres object
(the result of a call to pro_flux) to assess the quality of the model.
}
\details{
For error_concentration, the way the error parameter is calculated
for cfp_fgres and cfp_pfres objects is entirely different and should not be
used in comparison between the two. NRMSE of cfp_pfres objects are
calculated as the mean of depth-wise NRMSEs of modelled versus input gas
concentrations. 'NRMSE's of cfp_fgres objects simply calculate the mean of
(dcdz_sd / dcdz_ppm) per group described in param_cols.
}
\examples{
PROFLUX <- pro_flux(base_dat)

error_concentration(PROFLUX)
error_efflux(
  PROFLUX,
  EFFLUX = data.frame(efflux = 1),
  param_cols = c("site"))

}
