% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpA.measures.R
\name{measures_nonsimplifyingness_NP}
\alias{measures_nonsimplifyingness_NP}
\title{Compute a measure of non-simplifyingness based on non-parametric estimation
of the conditional copula}
\usage{
measures_nonsimplifyingness_NP(
  X1,
  X2,
  Z,
  h,
  measures = "all",
  kernel.name = "Epanechnikov",
  truncVal = NULL,
  numericalInt = list(kind = "legendre", nGrid = 10),
  verbose = 0
)
}
\arguments{
\item{X1, X2}{vector of \code{n} observations of the conditioned variables}

\item{Z}{vector of \code{n} observations of the conditioning variable}

\item{h}{the bandwidth used for kernel smoothing}

\item{measures}{choices of measures of non-simplifyingness to be computed.
\code{measures = "all"} includes all available non-parametric measures of
non-simplifyingness. Otherwise, \code{measures} must be a character vector
and a subset of \code{c("T1_CvM_Cs3", "T1_CvM_Cs4", "tilde_T0_CvM", }
\code{"T1_KS_Cs3", "T1_KS_Cs4", "tilde_T0_KS")}.}

\item{kernel.name}{the name of the kernel}

\item{truncVal}{the value of truncation for the integral,
i.e. the integrals are computed from \code{truncVal} to \code{1-truncVal}
instead of from 0 to 1.
Note that \code{truncVal} must be in the interval \eqn{[0, 0.5)},
i.e. \eqn{0} is allowed but not \eqn{0.5}.

The default is \code{truncVal = NULL}, which actually means that
\code{truncVal = h} if \code{h < 0.5} and \code{truncVal = 0} else.}

\item{numericalInt}{parameters to be given to
\code{statmod::\link[statmod]{gauss.quad}}, including the number of
quadrature points and the type of interpolation.}

\item{verbose}{option used for debugging. If \code{verbose = 0}, the function
is silent. Higher values of \code{verbose} give more explicit details on the
computations.}
}
\value{
a data.frame where each row corresponds to one measure of
non-simplifyingness and one choice of \code{h}.
As a particular case, if \code{measures} and \code{h} are both of length 1,
this data.frame will have only one row.
}
\description{
Compute a measure of non-simplifyingness based on non-parametric estimation
of the conditional copula
}
\examples{
set.seed(1)
N = 500
Z = rnorm(n = N, mean = 5, sd = 2)
conditionalTau = 0.8
simCopula = VineCopula::BiCopSim(N=N , family = 1,
    par = VineCopula::BiCopTau2Par(1 , conditionalTau ))
X1 = qnorm(simCopula[,1], mean = Z)
X2 = qnorm(simCopula[,2], mean = - Z)

result <- measures_nonsimplifyingness_NP(
   X1 = X1, X2 = X2, Z = Z, h = 0.08, measures = "tilde_T0_CvM")

result <- measures_nonsimplifyingness_NP(
   X1 = X1, X2 = X2, Z = Z, h = 0.08, measures = "all")


}
\references{
Derumigny, A. (2025). Measures of non-simplifyingness for conditional copulas
and vines. ArXiv preprint, arXiv:2504.07704.
\doi{10.48550/arXiv.2504.07704}
}
\seealso{
\code{\link{simpA.NP}()} for non-parametric tests of the simplifying
assumption.
}
