% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfigParser.R
\docType{class}
\name{configParser-class}
\alias{configParser-class}
\alias{ConfigParser}
\title{R6 object to parse an INI file}
\description{
This class creates an object that represents an INI file. It
also supports interpolation of variables of the form \code{\%(...)s}.
More detail on how the interpolation works in given in the
explanation of method \code{get}.
}
\section{Methods}{

\describe{
\item{\code{new(init = NULL, optionxform = tolower)}}{

 Initializes the object

Initializes the object, optionally with pre-set variables given
as a list or an environment

\strong{Parameters:}
\describe{
\item{init}{A named character vector, named list or an environment of variables to pre-set (the will be
put into the \code{DEFAULT} section)}
\item{optionxform}{Function through which all option and section names are funneled. By default \code{tolower}
to make all names lowercase. To switch off, pass in \code{identity}}
}}

\item{\code{read(filepath, encoding = getOption("encoding"))}}{

Read in an INI file

Reads the INI given into the object. It will be added to the
internal storage of the object. If applying these functions
several times, later definitions overwrite those that
were read earlier.

\strong{Parameters:}
\describe{
\item{filepath}{The path to the INI file.}
\item{encoding}{The encoding to use}
}

\strong{Return:}

The object, but with the added data of the file


}

\item{\code{write(filepath, encoding = getOption("encoding"))}}{

Write an INI file

Write the ConfigParser object into the INI file. It writes all the different sections
using uninterpolated variables.



\strong{Parameters:}
\describe{
\item{filepath}{The path to the INI file.}
\item{encoding}{The encoding to use}
}

\strong{Return:}

The ConfigParser object itself


}

\item{\code{get(option, fallback, section = "default", interpolate = TRUE)}}{

Get the value of a option



\strong{Parameters:}
\describe{
\item{option}{The option for which to get the value}
\item{fallback}{The fallback value to return if there is no value for the option. If missing,
an error will be thrown if the option has no value.}
\item{section}{The section (or several) from which to read the option. It will try to read the
option in the given section from first to last, with \code{DEFAULT} always being the
last}
\item{interpolate}{Should the values be interpolated. This will try to replace variables of
the form \code{\%(...)s}}
}

\strong{Return:}

The value of the option


}

\item{\code{getboolean(option, fallback, section = "default", interpolate = TRUE)}}{

Same as \code{get}, but results coerced to a logical.}

\item{\code{getfloat(option, fallback, section = "default", interpolate = TRUE)}}{

Same as \code{get}, but the result coerced to a float.}

\item{\code{set(option, value, section, error_on_new_section = TRUE)}}{

Set option to a value in a section

Sets an option to the given value (which can include variables for
interpolation) in the given section.

\strong{Parameters:}
\describe{
\item{option}{Name of the option to set (can be a character vector)}
\item{value}{Value of the option (same length as \code{option})}
\item{section}{Character vector of length 1}
\item{error_on_new_section}{Should an error be raised if the section does
not exist yet}
}

\strong{Return:}

Return of the adjusted \code{ConfigParser} object itself


}
}}

