% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_var_info.R
\name{get_var_info}
\alias{get_var_info}
\title{Get information regarding CongressData variables}
\usage{
get_var_info(var_names = NULL, related_to = NULL)
}
\arguments{
\item{var_names}{Default is NULL. Takes a character string. If left blank the
function does not subset by variable name. Note that this searches variable names,
it does not subset by the specific string you provide. So "over65" will return a
variable called 'over65' along with another called 'percent_over65'.}

\item{related_to}{Default is NULL. Takes a character string. If the user supplies
a character string, the function searches the other relevant fields (variable name, short/long
description, and source) for string matches. Not case sensitive.}
}
\value{
A tibble with information about variables in the CongressData dataset.
The tibble contains the following columns:

\itemize{
\item \code{variable}: The name of the variable.
\item \code{years}: The years the variable is observed.
\item \code{short_desc}: A short description of the variable.
\item \code{long_desc}: A long description of the variable.
\item \code{source}: The source of the data.
\item \code{citation}: The citation for the data, available in bibtex and plain text.
}
The tibble is filtered based on the provided \code{var_names} and \code{related_to} parameters.
}
\description{
\code{get_var_info} retrieves information regarding variables in the CongressData dataset.
The information available includes: the years each variable is observed in the data;
a short and long description of each variable; and the source and citation/s for each
variable. Citations are available in both bibtex and plain text.
}
\details{
Specifying no arguments returns all the information for all the variables
in the CongressData dataset.
}
\examples{

# returns all variable information
get_var_info()

# match var names that contain "over65" - note this returns multiple variables
get_var_info(var_names = "over65")

get_var_info(related_to = c("pop","femal"))

}
