% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifiability.R
\name{identifiability}
\alias{identifiability}
\title{Identifiability of  two-parameter copula families}
\usage{
identifiability(data = NULL, family, rotation = 0, Fx = NULL, Fy = NULL)
}
\arguments{
\item{data}{Matrix or data frame with 2 columns (X,Y). Can be pseudo-observations. If NULL, Fx and Fy must be provided.}

\item{family}{Copula family: "gaussian", "t", "clayton", "frank", "gumbel", "joe", "plackett'', "bb1", "bb6", "bb7","bb8","ncs-gaussian", "ncs-clayton", "ncs-gumbel", "ncs-frank", "ncs-joe","ncs-plackett".}

\item{rotation}{Rotation: 0 (default value), 90, 180, or 270.}

\item{Fx}{Marginal cdf function applied to X (default is NULL).}

\item{Fy}{Marginal cdf function  applied to  Y (default is NULL).}
}
\value{
\item{out}{True or False}
}
\description{
Determines if a copula family is identifiable with respect to the empirical margins. One-parameter copula families ("gaussian","gumbel","clayton","frank","plackett","joe") are identifiable whatever the margins. The rank of the gradient of the copula on the range of the margins is evaluated at 10000 parameter points within the lower and upper bounds of the copula family.
}
\examples{
set.seed(1)
data = matrix(rpois(20,1),ncol=2)
out = identifiability(data,"gumbel")


}
\references{
Nasri & Remillard (2023). Identifiability and inference for copula-based semiparametric models for random vectors with arbitrary marginal distributions. arXiv 2301.13408.

Nasri (2020). On non-central squared copulas. Statistics and Probability Letters.
}
