% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statcvm.R
\name{statcvm}
\alias{statcvm}
\title{Goodness-of-fit statistics}
\usage{
statcvm(object)
}
\arguments{
\item{object}{Object of class `EstBiCop`.}
}
\value{
\item{Sn}{Cramer-von Mises statistic}

\item{Tn}{Kendall's statistic}

\item{Rn}{Spearman's statistic}

\item{tauemp}{Empirical Kendall's tau}

\item{tauth}{Kendall's tau of the multilineat theoretical copula}

\item{rhoemp}{Empirical Spearman's rho}

\item{rhoth}{Spearman's rho of the multilineat theoretical copula}

\item{Y1}{Ordered observed values of X1}

\item{F1}{Empirical cdf of Y1}

\item{Y2}{Ordered observed values of X2}

\item{F2}{Empirical cdf of Y2}

\item{cpar}{Copula parameters}

\item{family}{Copula family}

\item{rotation}{Rotation value}

\item{n}{Sample size}
}
\description{
Computation of goodness-of-fit statistics (Cramer-von Mises and the Kendall's tau)
}
\examples{
set.seed(2)
data = matrix(rpois(20,1),ncol=2)
out0 = EstBiCop(data,"gumbel")
out = statcvm(out0)


}
\references{
Nasri & Remillard (2023). Identifiability and inference for copula-based semiparametric models for random vectors with arbitrary marginal distributions. arXiv 2301.13408.
}
