% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hypothesis.R
\name{get_hypothesis}
\alias{get_hypothesis}
\title{Construct hypothesis matrix and vector from linear covariance model structure}
\usage{
get_hypothesis(v0, V)
}
\arguments{
\item{v0}{A numeric vector of length \code{p} (number of parameters). Represents the
parameter vector at which the hypothesis is to be evaluated.}

\item{V}{A numeric matrix of size \verb{p x q}, representing the structured design or constraint matrix
for the model. Here, the vectorised matrices from the linear covariance structure model build the columns of
V.}
}
\value{
A list with two elements:
\describe{
\item{\code{Hypothesenmatrix}}{A numeric matrix \code{C} such that the hypothesis can be written as \code{C \%*\% theta = zeta}}
\item{\code{Hypothesenvector}}{The numeric vector \code{zeta}, computed as \code{C \%*\% v0}}
}
}
\description{
Computes a hypothesis matrix \code{C} and hypothesis vector \code{zeta} based on a given
parameter vector \code{v0} and a matrix \code{V} representing the model structure
(e.g., vectorised components of a linear covariance structure model).
}
\details{
The function extends \code{V} to full rank using \link{get_extended_matrix}, constructs a contrast
matrix \code{E} for the complement of the model-implied space, and computes the corresponding hypothesis matrix \code{C}.
}
\examples{
# Load the data
data("EEGwide", package = "MANOVA.RM")

X <- t(as.matrix(EEGwide[EEGwide$sex == "W" & EEGwide$diagnosis == "AD",
                         c("brainrate_temporal", "brainrate_frontal","brainrate_central",
                            "complexity_temporal","complexity_frontal", "complexity_central")]))
v0 <- rep(0,21)
v_auxiliary <- c(1, rep(0,5), 1, rep(0,4), 1, rep(0,3), 1, rep(0,2), 1, 0, 1)
V <- cbind(v_auxiliary, 1-v_auxiliary)
h <- get_hypothesis(v0,V)
set.seed(123)
test_covariance(X = X,C = h$hypothesis_matrix, Xi = h$hypothesis_vector,
                method = "MC", repetitions = 1000)

}
\references{
Sattler, P. and Dobler, D. (2025). Testing for patterns and structures in covariance and correlation matrices. \emph{arXiv preprint} \url{https://arxiv.org/abs/2310.11799}
}
